//+------------------------------------------------------------------+
//|                                                MA Difference.mq4 |
//|                                         from EMA Angle indicator |
//|                                                            mason |
//+------------------------------------------------------------------+
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  White
#property  indicator_color2  LimeGreen
#property  indicator_color3  Goldenrod
#property  indicator_level1  0

//---- indicator parameters
extern int StartEMAShift=4;
extern int EndEMAShift=0;
extern double AngleTreshold=0;
extern int MAPeriod=3;
extern int MAMethod=0;
extern int MAAppliedPrice = 4;
extern bool SoundON=false;
extern bool EmailON=false;
extern bool Absolute=false;

//---- indicator buffers
double UpBuffer[];
double ZeroBuffer[];
double DownBuffer[];
int flagval1 = 0;
int flagval2 = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(3);
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,2);
//   SetLevelValue(2,AngleTreshold);
//   SetLevelValue(3,-AngleTreshold);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));

//---- 3 indicator buffers mapping
   if(!SetIndexBuffer(0,ZeroBuffer) &&
      !SetIndexBuffer(1,UpBuffer) &&
      !SetIndexBuffer(2,DownBuffer))
      Print("cannot set indicator buffers!");
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("MA Difference ("+DoubleToStr(StartEMAShift,0)+" - "+DoubleToStr(EndEMAShift,0)+" - "+DoubleToStr(AngleTreshold,4)+")");
//---- initialization done
   return(0);
}
//+------------------------------------------------------------------+
//| The angle for EMA                                                |
//+------------------------------------------------------------------+
int start()
{
   double fEndMA, fStartMA;
   double fAngle, mFactor, dFactor;
   int nLimit, i;
   int nCountedBars;
   double angle;
   int ShiftDif;
   string Sym;
 
   if(EndEMAShift >= StartEMAShift)
   {
      Print("Error: EndEMAShift >= StartEMAShift");
      StartEMAShift = 6;
      EndEMAShift = 0;      
   }  
         
   nCountedBars = IndicatorCounted();
//---- check for possible errors
   if(nCountedBars<0) 
      return(-1);
//---- last counted bar will be recounted
   if(nCountedBars>0) 
      nCountedBars--;
   nLimit = Bars-nCountedBars;
//---- main loop
   for(i=0; i<nLimit; i++)
   {
      fEndMA=iMA(NULL,0,MAPeriod,0,MAMethod,MAAppliedPrice,i+EndEMAShift);
      fStartMA=iMA(NULL,0,MAPeriod,0,MAMethod,MAAppliedPrice,i+StartEMAShift);
      if(Absolute) fAngle = MathAbs(fEndMA - fStartMA); else fAngle = (fEndMA - fStartMA);

      DownBuffer[i] = 0.0;
      UpBuffer[i] = 0.0;
      ZeroBuffer[i] = fAngle;
      
      if(fAngle > AngleTreshold)
      {
         if (i == 1 && flagval1==0)
         {
           flagval1=1;
           flagval2=0;
           if (SoundON) Alert("Slope is UP","\n Symbol=",Symbol()," Period=",Period());
           if (EmailON) SendMail("Slope is UP", "Symbol="+Symbol()+" Period="+Period());
         }
         UpBuffer[i] = fAngle;
      }
      else if (fAngle < -AngleTreshold)
      {
         if (i == 1 && flagval2==0)
         {
          flagval2=1;
          flagval1=0;
          if (SoundON) Alert("Slope is DOWN","\n Symbol=",Symbol()," Period=",Period());
          if (EmailON) SendMail("Slope is Down","Symbol="+Symbol()+" Period="+Period());
         }
         DownBuffer[i] = fAngle;
      }
      else ZeroBuffer[i] = fAngle;
      
   }

   return(0);
  }
//+------------------------------------------------------------------+

